
Type TInteractiveAngleJoint 

	Field _angle1:Float
	Field _angle2:Float
	Field _angle3:Float
	Field _angle4:Float
	Field _angleMin:Float
	Field _angleMax:Float
	Field _circularInterpolator:TCircularInterpolator
	Field _revoluteJoint:TRevoluteJoint
	Field _angleJoint:TAngleJoint
	Field _softness:Float
	Field _body1:TBody
	Field _body2:TBody
	Field _anchor:Vector2 = Vector2.Zero()
	
	Method GetRevoluteJoint:TRevoluteJoint()
		Return _revoluteJoint
	End Method
	
	Method SetRevolutJoint(value:TRevoluteJoint)
		_revoluteJoint = value
	End Method
	
	Method GetAngleJoint:TAngleJoint()
		Return _angleJoint
	End Method
	
	Method SetAngleJoint(value:TAngleJoint)
		_angleJoint = value
	End Method
	
	Function Create:TInteractiveAngleJoint(angle1:Float, angle2:Float, angle3:Float, angle4:Float, angleMin:Float, angleMax:Float, softness:Float, anchor:Vector2, body1:TBody, body2:TBody)
		Local joint:TInteractiveAngleJoint = New TInteractiveAngleJoint
		joint._angle1 = angle1
		joint._angle2 = angle2
		joint._angle3 = angle3
		joint._angle4 = angle4
		joint._angleMin = angleMin
		joint._angleMax = angleMax
		joint._softness = softness
		joint._anchor.Set(anchor)
		joint._body1 = body1
		joint._body2 = body2
		
		joint._revoluteJoint = TRevoluteJoint.Create(body1, body2, anchor)
		joint._revoluteJoint.SetSoftness(softness)
		joint._angleJoint = TAngleJoint.Create(body1, body2)
		joint._circularInterpolator = TCircularInterpolator.Create(angle1, angle2, angle3, angle4, anglemin, anglemax)
		
		return joint
	End Function
	
	Method Load(physics:TPhysicsSimulator)
		physics.AddJoint(_revoluteJoint)
		physics.AddJoint(_angleJoint)
	End Method
	
	Method Unload(physics:TPhysicsSimulator)
		physics.RemoveJoint(_revoluteJoint)
		physics.RemoveJoint(_angleJoint)
	End Method
	
	Method CalculateJoint(x:Float, y:Float)
		Local angle:Float = _circularInterpolator.GetValue(x, y)
		_angleJoint.SetTargetAngle(angle)
	End Method
End Type
